/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.utils.NodeVector;
import com.sun.org.apache.xpath.internal.NodeSetDTM;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.util.Vector;

public class NodeSequence
extends XObject
implements DTMIterator,
Cloneable,
PathComponent {
    static final long serialVersionUID = 3866261934726581044L;
    protected int m_last = -1;
    protected int m_next = 0;
    private IteratorCache m_cache;
    protected DTMIterator m_iter;
    protected DTMManager m_dtmMgr;

    protected NodeVector getVector() {
        NodeVector nodeVector = this.m_cache != null ? this.m_cache.getVector() : null;
        return nodeVector;
    }

    private IteratorCache getCache() {
        return this.m_cache;
    }

    protected void SetVector(NodeVector nodeVector) {
        this.setObject(nodeVector);
    }

    public boolean hasCache() {
        NodeVector nodeVector = this.getVector();
        return nodeVector != null;
    }

    private boolean cacheComplete() {
        boolean bl = this.m_cache != null ? this.m_cache.isComplete() : false;
        return bl;
    }

    private void markCacheComplete() {
        NodeVector nodeVector = this.getVector();
        if (nodeVector != null) {
            this.m_cache.setCacheComplete(true);
        }
    }

    public final void setIter(DTMIterator dTMIterator) {
        this.m_iter = dTMIterator;
    }

    public final DTMIterator getContainedIter() {
        return this.m_iter;
    }

    private NodeSequence(DTMIterator dTMIterator, int n, XPathContext xPathContext, boolean bl) {
        this.setIter(dTMIterator);
        this.setRoot(n, xPathContext);
        this.setShouldCacheNodes(bl);
    }

    public NodeSequence(Object object) {
        super(object);
        if (object instanceof NodeVector) {
            this.SetVector((NodeVector)object);
        }
        if (null != object) {
            this.assertion(object instanceof NodeVector, "Must have a NodeVector as the object for NodeSequence!");
            if (object instanceof DTMIterator) {
                this.setIter((DTMIterator)object);
                this.m_last = ((DTMIterator)object).getLength();
            }
        }
    }

    private NodeSequence(DTMManager dTMManager) {
        super(new NodeVector());
        this.m_last = 0;
        this.m_dtmMgr = dTMManager;
    }

    public NodeSequence() {
    }

    @Override
    public DTM getDTM(int n) {
        DTMManager dTMManager = this.getDTMManager();
        if (null != dTMManager) {
            return this.getDTMManager().getDTM(n);
        }
        this.assertion(false, "Can not get a DTM Unless a DTMManager has been set!");
        return null;
    }

    @Override
    public DTMManager getDTMManager() {
        return this.m_dtmMgr;
    }

    @Override
    public int getRoot() {
        if (null != this.m_iter) {
            return this.m_iter.getRoot();
        }
        return -1;
    }

    @Override
    public void setRoot(int n, Object object) {
        if (n == -1) {
            throw new RuntimeException("Unable to evaluate expression using this context");
        }
        if (null != this.m_iter) {
            XPathContext xPathContext = (XPathContext)object;
            this.m_dtmMgr = xPathContext.getDTMManager();
            this.m_iter.setRoot(n, object);
            if (!this.m_iter.isDocOrdered()) {
                if (!this.hasCache()) {
                    this.setShouldCacheNodes(true);
                }
                this.runTo(-1);
                this.m_next = 0;
            }
        } else {
            this.assertion(false, "Can not setRoot on a non-iterated NodeSequence!");
        }
    }

    @Override
    public void reset() {
        this.m_next = 0;
    }

    @Override
    public int getWhatToShow() {
        return this.hasCache() ? -17 : this.m_iter.getWhatToShow();
    }

    @Override
    public boolean getExpandEntityReferences() {
        if (null != this.m_iter) {
            return this.m_iter.getExpandEntityReferences();
        }
        return true;
    }

    @Override
    public int nextNode() {
        NodeVector nodeVector = this.getVector();
        if (null != nodeVector) {
            if (this.m_next < nodeVector.size()) {
                int n = nodeVector.elementAt(this.m_next);
                ++this.m_next;
                return n;
            }
            if (this.cacheComplete() || -1 != this.m_last || null == this.m_iter) {
                ++this.m_next;
                return -1;
            }
        }
        if (null == this.m_iter) {
            return -1;
        }
        int n = this.m_iter.nextNode();
        if (-1 != n) {
            if (this.hasCache()) {
                if (this.m_iter.isDocOrdered()) {
                    this.getVector().addElement(n);
                    ++this.m_next;
                } else {
                    int n2 = this.addNodeInDocOrder(n);
                    if (n2 >= 0) {
                        ++this.m_next;
                    }
                }
            } else {
                ++this.m_next;
            }
        } else {
            this.markCacheComplete();
            this.m_last = this.m_next++;
        }
        return n;
    }

    @Override
    public int previousNode() {
        if (this.hasCache()) {
            if (this.m_next <= 0) {
                return -1;
            }
            --this.m_next;
            return this.item(this.m_next);
        }
        int n = this.m_iter.previousNode();
        this.m_next = this.m_iter.getCurrentPos();
        return this.m_next;
    }

    @Override
    public void detach() {
        if (null != this.m_iter) {
            this.m_iter.detach();
        }
        super.detach();
    }

    @Override
    public void allowDetachToRelease(boolean bl) {
        if (!bl && !this.hasCache()) {
            this.setShouldCacheNodes(true);
        }
        if (null != this.m_iter) {
            this.m_iter.allowDetachToRelease(bl);
        }
        super.allowDetachToRelease(bl);
    }

    @Override
    public int getCurrentNode() {
        if (this.hasCache()) {
            int n = this.m_next - 1;
            NodeVector nodeVector = this.getVector();
            if (n >= 0 && n < nodeVector.size()) {
                return nodeVector.elementAt(n);
            }
            return -1;
        }
        if (null != this.m_iter) {
            return this.m_iter.getCurrentNode();
        }
        return -1;
    }

    @Override
    public boolean isFresh() {
        return 0 == this.m_next;
    }

    @Override
    public void setShouldCacheNodes(boolean bl) {
        if (bl) {
            if (!this.hasCache()) {
                this.SetVector(new NodeVector());
            }
        } else {
            this.SetVector(null);
        }
    }

    @Override
    public boolean isMutable() {
        return this.hasCache();
    }

    @Override
    public int getCurrentPos() {
        return this.m_next;
    }

    @Override
    public void runTo(int n) {
        if (-1 == n) {
            int n2;
            int n3 = this.m_next;
            while (-1 != (n2 = this.nextNode())) {
            }
            this.m_next = n3;
        } else {
            if (this.m_next == n) {
                return;
            }
            if (this.hasCache() && n < this.getVector().size()) {
                this.m_next = n;
            } else if (null == this.getVector() && n < this.m_next) {
                int n4;
                while (this.m_next >= n && -1 != (n4 = this.previousNode())) {
                }
            } else {
                int n5;
                while (this.m_next < n && -1 != (n5 = this.nextNode())) {
                }
            }
        }
    }

    @Override
    public void setCurrentPos(int n) {
        this.runTo(n);
    }

    @Override
    public int item(int n) {
        this.setCurrentPos(n);
        int n2 = this.nextNode();
        this.m_next = n;
        return n2;
    }

    @Override
    public void setItem(int n, int n2) {
        NodeVector nodeVector = this.getVector();
        if (null != nodeVector) {
            int n3 = nodeVector.elementAt(n2);
            if (n3 != n && this.m_cache.useCount() > 1) {
                NodeVector nodeVector2;
                IteratorCache iteratorCache = new IteratorCache();
                try {
                    nodeVector2 = (NodeVector)nodeVector.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                    RuntimeException runtimeException = new RuntimeException(cloneNotSupportedException.getMessage());
                    throw runtimeException;
                }
                iteratorCache.setVector(nodeVector2);
                iteratorCache.setCacheComplete(true);
                this.m_cache = iteratorCache;
                nodeVector = nodeVector2;
                super.setObject(nodeVector2);
            }
            nodeVector.setElementAt(n, n2);
            this.m_last = nodeVector.size();
        } else {
            this.m_iter.setItem(n, n2);
        }
    }

    @Override
    public int getLength() {
        IteratorCache iteratorCache = this.getCache();
        if (iteratorCache != null) {
            if (iteratorCache.isComplete()) {
                NodeVector nodeVector = iteratorCache.getVector();
                return nodeVector.size();
            }
            if (this.m_iter instanceof NodeSetDTM) {
                return this.m_iter.getLength();
            }
            if (-1 == this.m_last) {
                int n = this.m_next;
                this.runTo(-1);
                this.m_next = n;
            }
            return this.m_last;
        }
        return -1 == this.m_last ? (this.m_last = this.m_iter.getLength()) : this.m_last;
    }

    @Override
    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSequence nodeSequence = (NodeSequence)super.clone();
        nodeSequence.m_next = 0;
        if (this.m_cache != null) {
            this.m_cache.increaseUseCount();
        }
        return nodeSequence;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NodeSequence nodeSequence = (NodeSequence)super.clone();
        if (null != this.m_iter) {
            nodeSequence.m_iter = (DTMIterator)this.m_iter.clone();
        }
        if (this.m_cache != null) {
            this.m_cache.increaseUseCount();
        }
        return nodeSequence;
    }

    @Override
    public boolean isDocOrdered() {
        if (null != this.m_iter) {
            return this.m_iter.isDocOrdered();
        }
        return true;
    }

    @Override
    public int getAxis() {
        if (null != this.m_iter) {
            return this.m_iter.getAxis();
        }
        this.assertion(false, "Can not getAxis from a non-iterated node sequence!");
        return 0;
    }

    @Override
    public int getAnalysisBits() {
        if (null != this.m_iter && this.m_iter instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_iter)).getAnalysisBits();
        }
        return 0;
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
    }

    protected int addNodeInDocOrder(int n) {
        int n2;
        this.assertion(this.hasCache(), "addNodeInDocOrder must be done on a mutable sequence!");
        int n3 = -1;
        NodeVector nodeVector = this.getVector();
        int n4 = nodeVector.size();
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n5 = nodeVector.elementAt(n2);
            if (n5 == n) {
                n2 = -2;
                break;
            }
            DTM dTM = this.m_dtmMgr.getDTM(n);
            if (!dTM.isNodeAfter(n, n5)) break;
        }
        if (n2 != -2) {
            n3 = n2 + 1;
            nodeVector.insertElementAt(n, n3);
        }
        return n3;
    }

    @Override
    protected void setObject(Object object) {
        if (object instanceof NodeVector) {
            super.setObject(object);
            NodeVector nodeVector = (NodeVector)object;
            if (this.m_cache != null) {
                this.m_cache.setVector(nodeVector);
            } else if (nodeVector != null) {
                this.m_cache = new IteratorCache();
                this.m_cache.setVector(nodeVector);
            }
        } else if (object instanceof IteratorCache) {
            IteratorCache iteratorCache;
            this.m_cache = iteratorCache = (IteratorCache)object;
            this.m_cache.increaseUseCount();
            super.setObject(iteratorCache.getVector());
        } else {
            super.setObject(object);
        }
    }

    protected IteratorCache getIteratorCache() {
        return this.m_cache;
    }

    private static final class IteratorCache {
        private NodeVector m_vec2 = null;
        private boolean m_isComplete2 = false;
        private int m_useCount2 = 1;

        IteratorCache() {
        }

        private int useCount() {
            return this.m_useCount2;
        }

        private void increaseUseCount() {
            if (this.m_vec2 != null) {
                ++this.m_useCount2;
            }
        }

        private void setVector(NodeVector nodeVector) {
            this.m_vec2 = nodeVector;
            this.m_useCount2 = 1;
        }

        private NodeVector getVector() {
            return this.m_vec2;
        }

        private void setCacheComplete(boolean bl) {
            this.m_isComplete2 = bl;
        }

        private boolean isComplete() {
            return this.m_isComplete2;
        }
    }
}

